---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：17-活性化関数（Activation Functions）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **GPU上でのカーネル融合**：C++実装の内部は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/keras/activations.py` 全体（590行）
- E-02: `tensorflow/python/keras/layers/advanced_activations.py` 1-100行目
- E-03: `tensorflow/python/keras/activations.py` 40-92行目 softmax
- E-04: `tensorflow/python/keras/activations.py` 96-141行目 elu
- E-05: `tensorflow/python/keras/activations.py` 268-305行目 relu
- E-06: `tensorflow/python/keras/activations.py` 369-397行目 sigmoid
- E-07: `tensorflow/python/keras/activations.py` 468-495行目 serialize
- E-08: `tensorflow/python/keras/activations.py` 507-545行目 deserialize
- E-09: `tensorflow/python/keras/activations.py` 549-589行目 get
- E-10: `tensorflow/python/keras/activations.py` 500-503行目 aliases (silu, leaky_relu等)
- E-11: `tensorflow/python/keras/layers/advanced_activations.py` 33-86行目 LeakyReLU
- E-12: 機能一覧.csv No.17の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | softmaxは1Dテンソルに適用不可 | E-03 (78, 87-88行目) | ○ |
| C-02 | softmax出力に_keras_logitsをキャッシュ | E-03 (91行目) | ○ |
| C-03 | sigmoid出力に_keras_logitsをキャッシュ | E-06 (396行目) | ○ |
| C-04 | タプル軸のsoftmaxは手動計算 | E-03 (81-85行目) | ○ |
| C-05 | eluはbackend.eluに委譲 | E-04 (141行目) | ○ |
| C-06 | seluはnn.seluに委譲 | E-01 (194行目) | ○ |
| C-07 | reluはbackend.reluに委譲 | E-05 (305行目) | ○ |
| C-08 | geluはnn.geluに委譲 | E-01 (344行目) | ○ |
| C-09 | swishはnn.swishに委譲 | E-01 (265行目) | ○ |
| C-10 | hard_sigmoidはbackend.hard_sigmoidに委譲 | E-01 (445行目) | ○ |
| C-11 | linearはxをそのまま返す | E-01 (465行目) | ○ |
| C-12 | silu = nn.swish のエイリアス | E-10 (503行目) | ○ |
| C-13 | v2名前のリマッピング(softmax_v2等) | E-07 (492-494行目) | ○ |
| C-14 | deserializeでadvanced_activations_globsを統合 | E-08 (536-539行目) | ○ |
| C-15 | getでNone -> linear | E-09 (577-578行目) | ○ |
| C-16 | LeakyReLUのalpha=Noneでエラー | E-11 (69-72行目) | ○ |
| C-17 | LeakyReLUはbackend.relu(alpha=)に委譲 | E-11 (76-77行目) | ○ |
| C-18 | PReLUは学習可能なalpha | E-02 (89行目〜 docstring) | ○ |
| C-19 | GELU近似式 | E-01 (335行目 docstring) | ○ |
| C-20 | GPU上でのカーネル融合最適化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: カーネル融合はXLA/cuDNNの最適化に依存し、Pythonソースからは確認できない
  - 候補：XLAコンパイラソース / cuDNN統合コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての関数型活性化関数はソースコードで確認済み
- 0: 低リスク - レイヤー型活性化関数の主要部分も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各活性化関数の数学的定義が正確か確認
- [ ] _keras_logitsキャッシュの利用先（crossentropy）が正しいか確認
- [ ] PReLUの完全な実装（advanced_activations.py後半）を確認
